/* ---------------------------------------------------------
 * Ene Mene Muh v2
 * Copyright (c) 2004 Sebastian Kienzl <seb@riot.org>
 * ---------------------------------------------------------
 * $Id: main.c 41 2009-01-25 17:24:53Z seb $
 * 2004-11-11, fasching!
 * ---------------------------------------------------------
 * Das ist mein "Schalter" fuer den Saturn. Hab keine Lust
 * gehabt am Gehaeuse rumzumurksen, deswegen hab ichs so
 * gemacht.
 * Addons fr die Verwendung an einem MasterSystem mit 
 * einer RGB-Power-LED common Anode (Plus)
 * von Klaus Wolf www.wolfsoft.de
 */

#include <htc.h>
#define _XTAL_FREQ 4000000

/*
EEPROM:

Byte
0		current country is saved here		
1		current 50/60-setting is saved here

these can be modified before burning:
2		colour for EU	(1=green, 2=red, 3=orange)
3		colour for USA
4		colour for JAP
*/

__CONFIG( MCLRDIS & BOREN & PWRTEN & WDTDIS & INTOSCIO & UNPROTECT );
// Eprom Data (Byte0,Byte1,Byste2,...)
// Farbe fr usa gendert auf 
__EEPROM_DATA( 0, 0, 1, 4, 2, 0, 0, 0 );
__EEPROM_DATA( '_', '_', 's', 'e', 'b', '!', '_', '_' );
__IDLOC(2702);

#define BUTTON	RA0
#define	VF		RA1

#define	RST		RA2
#define RST_T	TRISA2

char currCountry;
//change to 2, da NeoGeo/SMS nur 2 Bios Versionen eingebaut hat in diesem MOD
#define COUNTRYNUM 2

const char countries_JP[ COUNTRYNUM ] = {
	// JP12/JP10/JP6
    // using JP12 and JP6 only
	0b110,	// eu 
	//0b010,	// usa
	0b001	// japan
	//^^^_____ RC2/RC1/RC0 (JP12/JP10/JP6)
};

// beim neogeo ist 50/60Hz invertiert ->
// und usa disabled, weil nur Countrynum 2
const char countries_VF[ COUNTRYNUM ] = {
	0,		// eu: 50hz
	// 0,		// usa: 60hz
	1		// japan: 60hz
};

//hier auch usa disabled weil nur Countrynum 2
char countries_COL[ COUNTRYNUM ] = {
	0b01,	// eu: gruen /blau	(1)
	// 0b11,	// usa: orange	(3)
	0b10	// japan: rot	(2)
	//^^______ RC5/RC4 (rot/gruen LED)
};

// approx. delay
void delay( int t )
{
	while( t-- ) {
		__delay_ms( 1 );
	}
}

void setCountry()
{
	PORTC = ( PORTC & 0b110000 ) |
			countries_JP[ currCountry ];
}

void setLeds()
{
	PORTC = ( PORTC & 0b000111 ) |
			( countries_COL[ currCountry ] << 4 );
}

void reset5060()
{
	VF = countries_VF[ currCountry ];
}

void darkenLeds( int msec )
// muss invertiert werden bei RGB-LEDs, da diese gemeinsame Anoden haben 
{
	RC4 = 1;
	RC5 = 1;
	delay( msec );
	setLeds();
}

void display5060( char dunkel )
{
	if( !dunkel ) {
		darkenLeds( 200 );
	}

	if( VF == 1 ) {
		// 60Hz: einmal blinken
		delay( 200 );
		darkenLeds( 200 );
	}
	else {
		int i;
		// 60Hz: schnell oefter blinken
		for( i = 0; i < 3; i++ ) {
			delay( 75 );
			darkenLeds( 75 );
		}
	}
}

void load()
{
	char c;
	int i;
	for( i = 0; i < COUNTRYNUM; i++ ) {
		c = eeprom_read( i + 2 );
		if( c >= 1 && c <= 3 ) {
			countries_COL[ i ] = c;
		}
	}

	currCountry = eeprom_read( 0 );
	if( currCountry >= COUNTRYNUM )
		currCountry = 0;
	setCountry();
	VF = eeprom_read( 1 );
	setLeds();
	display5060( 1 );
}

void save()
{
	eeprom_write( 0, currCountry );
	eeprom_write( 1, VF );
}

void reset()
{
	// auf 0 und output schalten
	RST = 0;
	RST_T = 0;
	delay( 200 );
	// wieder auf 1 und hi-z
	RST_T = 1;
	RST = 1;
}



void main()
{
	// internen oszillator konfigurieren
	OSCCAL = _READ_OSCCAL_DATA();

	PCON = 0;		// POR/BOD ist uns zwar egal, aber

	CMCON = 0b111;		// komparator aus!

	PORTA = 0;
	TRISA = 0b111101;
	// die anderen sind eingaenge, /RESET wird nur beim reset auf ausgang geschaltet

	// fuer wakeup bei sleep einstellen
	RAIE = 1;
	IOCA0 = 1;		// Interrupt On Change bei RA0 (Button)
//	GIE = 1;

	WPUA = 1;		// fuer alle pullup (damits nit floaten)
	WPUA1 = 1;		// kein pullup fuer /RESET
	RAPU = 0;		// individ. pullups an

	PORTC = 0;
	TRISC = 0b001000;	// JP/LED-Ausgaenge

	// settings laden
	load();

	while( 1 ) {
		// port change interrupt flag clear
		RAIF = 0;

		// warten bis reset-button gedrueckt wird
		SLEEP();

		// entprellen
		delay( 5 );

		// uns interessiert nur button-druck
		if( BUTTON != 0 )
			continue;

		delay( 250 );

		if( BUTTON ) {
			// schon wieder losgelassen -> normaler reset
			reset();
		}
		else {
			darkenLeds( 1000 );
		// umschalten 50/60 im Betrieb fuer sms nicht notwendig
			if( BUTTON ) {
				// ok, jetzt ist losgelassen, 50/60hz toggle
				
			//	VF ^= 1;
			//	save();
			//	display5060( 1 );
				// beim neo auch nach 50/60hz toogle ein reset
			//	reset();
			}
			else {
				// laender-code aendern?
				char change = 0;

				// mal das aktuelle anzeigen, hat man noch zeit zum aufhoeren druecken
				delay( 1000 );

				// reset noch immer gedrueckt, laender cyclen so lange gehalten wird!
				while( !BUTTON ) {
					change = 1;
					if( ++currCountry >= COUNTRYNUM )
						currCountry = 0;
					setLeds();
					delay( 1000 );
				}

				if( change ) {
					// land wurde veraendert, deswegen
					setCountry();
					// 50/60 entsprechend setzen (und blinken)
					reset5060();
					save();
					display5060( 0 );
			//		reset();
				}
			}
		}
	}
}
